import { useTranslations } from 'next-intl';


export default function GlobalNotFound() {
  const t = useTranslations('NotFound');

  return (
    <>
        <div className="flex flex-col items-center justify-center min-h-[60vh] text-center px-4">
        <h1 className="text-9xl font-bold text-main-blue font-main">
            <span>4</span>
            <span className='text-main-orange'>0</span>
            <span>4</span>
        </h1>
        <h2 className="text-2xl md:text-3xl font-bold mt-4 text-gray-800 font-main">
            {t('title')}
        </h2>
        <p className="text-gray-600 mt-2 max-w-md font-main">
            {t('description')}
        </p>
        </div>
    </>
  );
}